/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.mixins;

import fr.iglee42.evolvedmekanism.registries.EMBlockTypes;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.content.matrix.MatrixValidator;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MatrixValidator.class}, remap=false)
public class MatrixValidatorMixin
extends CuboidStructureValidator<MatrixMultiblockData> {
    @Shadow
    @Final
    private List<TileEntityInductionCell> cells;
    @Shadow
    @Final
    private List<TileEntityInductionProvider> providers;

    @Inject(method={"validateInner"}, at={@At(value="INVOKE", target="Lmekanism/common/content/blocktype/BlockType;is(Lnet/minecraft/world/level/block/Block;[Lmekanism/common/content/blocktype/BlockType;)Z")}, cancellable=true)
    private void evolvedmekanism$acceptCustomBlocks(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (BlockType.is((Block)state.m_60734_(), (BlockType[])new BlockType[]{EMBlockTypes.OVERCLOCKED_INDUCTION_CELL, EMBlockTypes.QUANTUM_INDUCTION_CELL, EMBlockTypes.DENSE_INDUCTION_CELL, EMBlockTypes.MULTIVERSAL_INDUCTION_CELL, EMBlockTypes.OVERCLOCKED_INDUCTION_PROVIDER, EMBlockTypes.QUANTUM_INDUCTION_PROVIDER, EMBlockTypes.DENSE_INDUCTION_PROVIDER, EMBlockTypes.MULTIVERSAL_INDUCTION_PROVIDER, EMBlockTypes.CREATIVE_INDUCTION_PROVIDER, EMBlockTypes.CREATIVE_INDUCTION_CELL})) {
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, (BlockPos)pos);
            if (tile instanceof TileEntityInductionCell) {
                TileEntityInductionCell cell = (TileEntityInductionCell)tile;
                this.cells.add(cell);
                cir.setReturnValue((Object)true);
            } else if (tile instanceof TileEntityInductionProvider) {
                TileEntityInductionProvider provider = (TileEntityInductionProvider)tile;
                this.providers.add(provider);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Unique
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.m_60734_();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{MekanismBlockTypes.INDUCTION_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{MekanismBlockTypes.INDUCTION_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }
}

